/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.block;

import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.block.BlockEntityDragonForge;
import com.iafenvoy.iceandfire.item.block.BlockDragonForgeInput;
import com.iafenvoy.iceandfire.registry.IafBlockEntities;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public class BlockEntityDragonForgeInput
extends class_2586 {
    private static final int LURE_DISTANCE = 50;
    private static final class_2350[] HORIZONTALS = new class_2350[]{class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039};
    private int ticksSinceDragonFire;
    private BlockEntityDragonForge core = null;

    public BlockEntityDragonForgeInput(class_2338 pos, class_2680 state) {
        super((class_2591)IafBlockEntities.DRAGONFORGE_INPUT.get(), pos, state);
    }

    public static void tick(class_1937 level, class_2338 position, class_2680 state, BlockEntityDragonForgeInput forgeInput) {
        if (forgeInput.core == null) {
            forgeInput.core = forgeInput.getConnectedTileEntity(position);
        }
        if (forgeInput.ticksSinceDragonFire > 0) {
            --forgeInput.ticksSinceDragonFire;
        }
        if ((forgeInput.ticksSinceDragonFire == 0 || forgeInput.core == null) && forgeInput.isActive()) {
            class_2586 tileentity = level.method_8321(position);
            level.method_8501(position, forgeInput.getDeactivatedState());
            if (tileentity != null) {
                tileentity.method_10996();
                level.method_8438(tileentity);
            }
        }
        if (forgeInput.isAssembled()) {
            forgeInput.lureDragons();
        }
    }

    public void onHitWithFlame() {
        if (this.core != null) {
            this.core.transferPower(1);
        }
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38242();
    }

    protected void lureDragons() {
        class_243 targetPosition = new class_243((double)((float)this.method_11016().method_10263() + 0.5f), (double)((float)this.method_11016().method_10264() + 0.5f), (double)((float)this.method_11016().method_10260() + 0.5f));
        class_238 searchArea = new class_238((double)this.field_11867.method_10263() - 50.0, (double)this.field_11867.method_10264() - 50.0, (double)this.field_11867.method_10260() - 50.0, (double)this.field_11867.method_10263() + 50.0, (double)this.field_11867.method_10264() + 50.0, (double)this.field_11867.method_10260() + 50.0);
        boolean dragonSelected = false;
        assert (this.field_11863 != null);
        for (EntityDragonBase dragon : this.field_11863.method_18467(EntityDragonBase.class, searchArea)) {
            if (!dragonSelected && this.getDragonType() == dragon.dragonType.getIntFromType() && (dragon.isChained() || dragon.method_6181()) && this.canSeeInput(dragon, targetPosition)) {
                dragon.burningTarget = this.field_11867;
                dragonSelected = true;
                continue;
            }
            if (dragon.burningTarget != this.field_11867) continue;
            dragon.burningTarget = null;
            dragon.setBreathingFire(false);
        }
    }

    public boolean isAssembled() {
        return this.core != null && this.core.assembled() && this.core.canSmelt();
    }

    private boolean canSeeInput(EntityDragonBase dragon, class_243 target) {
        if (target != null) {
            assert (this.field_11863 != null);
            class_3965 rayTrace = this.field_11863.method_17742(new class_3959(dragon.getHeadPosition(), target, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)dragon));
            double distance = dragon.getHeadPosition().method_1022(rayTrace.method_17784());
            return distance < (double)(10.0f + dragon.method_17681());
        }
        return false;
    }

    private class_2680 getDeactivatedState() {
        return switch (this.getDragonType()) {
            case 1 -> (class_2680)((class_2248)IafBlocks.DRAGONFORGE_ICE_INPUT.get()).method_9564().method_11657((class_2769)BlockDragonForgeInput.ACTIVE, (Comparable)Boolean.valueOf(false));
            case 2 -> (class_2680)((class_2248)IafBlocks.DRAGONFORGE_LIGHTNING_INPUT.get()).method_9564().method_11657((class_2769)BlockDragonForgeInput.ACTIVE, (Comparable)Boolean.valueOf(false));
            default -> (class_2680)((class_2248)IafBlocks.DRAGONFORGE_FIRE_INPUT.get()).method_9564().method_11657((class_2769)BlockDragonForgeInput.ACTIVE, (Comparable)Boolean.valueOf(false));
        };
    }

    private int getDragonType() {
        assert (this.field_11863 != null);
        class_2680 state = this.field_11863.method_8320(this.field_11867);
        if (state.method_26204() == IafBlocks.DRAGONFORGE_FIRE_INPUT.get()) {
            return 0;
        }
        if (state.method_26204() == IafBlocks.DRAGONFORGE_ICE_INPUT.get()) {
            return 1;
        }
        if (state.method_26204() == IafBlocks.DRAGONFORGE_LIGHTNING_INPUT.get()) {
            return 2;
        }
        return 0;
    }

    private boolean isActive() {
        assert (this.field_11863 != null);
        class_2680 state = this.field_11863.method_8320(this.field_11867);
        return state.method_26204() instanceof BlockDragonForgeInput && (Boolean)state.method_11654((class_2769)BlockDragonForgeInput.ACTIVE) != false;
    }

    private BlockEntityDragonForge getConnectedTileEntity(class_2338 position) {
        assert (this.field_11863 != null);
        for (class_2350 facing : HORIZONTALS) {
            class_2586 class_25862 = this.field_11863.method_8321(position.method_10093(facing));
            if (!(class_25862 instanceof BlockEntityDragonForge)) continue;
            BlockEntityDragonForge forge = (BlockEntityDragonForge)class_25862;
            return forge;
        }
        return null;
    }
}

